package com.yd.csf.feign.client.team;

import com.yd.common.result.Result;
import com.yd.csf.feign.fallback.team.ApiTeamFeignFallbackFactory;
import com.yd.csf.feign.request.team.ApiTeamListRequest;
import com.yd.csf.feign.request.team.ApiTeamPageRequest;
import com.yd.csf.feign.response.team.ApiTeamDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import java.util.List;

/**
 * 香港保险服务-团队信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiTeamFeignFallbackFactory.class)
public interface ApiTeamFeignClient {

    /**
     * 分页列表查询-团队信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiTeamPageRequest request);

    /**
     * 列表查询-团队信息
     * @param request
     * @return
     */
    @PostMapping("/list")
    Result<List<ApiTeamDetailResponse>> list(@RequestBody ApiTeamListRequest request);

}
