package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiBeneficiaryService;
import com.yd.csf.feign.client.beneficiary.ApiBeneficiaryFeignClient;
import com.yd.csf.feign.dto.appointment.ApiBeneficiaryInfoDto;
import com.yd.csf.feign.dto.appointment.ApiInsurantInfoDto;
import com.yd.csf.feign.request.beneficiary.ApiBeneficiaryPageRequest;
import com.yd.csf.feign.response.beneficiary.ApiBeneficiaryPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 预约-受益人信息
 *
 * @author zxm
 * @since 2025-09-01
 */
@RestController
@RequestMapping("/beneficiary")
public class ApiBeneficiaryController implements ApiBeneficiaryFeignClient {

    @Autowired
    private ApiBeneficiaryService apiBeneficiaryService;

    /**
     * 受益人信息分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiBeneficiaryPageResponse>> page(ApiBeneficiaryPageRequest request) {
        return null;
    }

    /**
     * 受益人信息列表查询
     * @param appointmentBizId
     * @return
     */
    @Override
    public Result<List<ApiBeneficiaryInfoDto>> list(String appointmentBizId) {
        return apiBeneficiaryService.list(appointmentBizId);
    }

    /**
     * 受益人信息详情
     * @param beneficiaryBizId 受益人信息表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiBeneficiaryInfoDto> detail(String beneficiaryBizId) {
        return apiBeneficiaryService.detail(beneficiaryBizId);
    }

    /**
     * 新增单个受益人信息
     * @param apiBeneficiaryInfoDto
     * @return
     */
    @Override
    public Result add(ApiBeneficiaryInfoDto apiBeneficiaryInfoDto) {
        return apiBeneficiaryService.add(apiBeneficiaryInfoDto);
    }

    /**
     * 编辑单个受益人信息
     * @param apiBeneficiaryInfoDto
     * @return
     */
    @Override
    public Result edit(ApiBeneficiaryInfoDto apiBeneficiaryInfoDto) {
        return apiBeneficiaryService.edit(apiBeneficiaryInfoDto);
    }

    /**
     * 删除单个受益人信息
     * @param beneficiaryBizId
     * @return
     */
    @Override
    public Result del(String beneficiaryBizId) {
        return apiBeneficiaryService.del(beneficiaryBizId);
    }
}
