package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Data
public class PolicyFollowUpdateRequest {

    /**
     * 新单编号
     */
    @Schema(description = "新单编号", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policyBizId;

    /**
     * 新单状态
     */
    @Schema(description = "新单状态 'CHECKING'-'审核中','UNDERWRITING'-'承保中','FINISHED'-'已完成','DECLINED'-'已拒绝','CANCELLED'-'已取消', 字典值: policy_follow_status")
    private String status;


    /**
     * 客户名称
     */
    @Schema(description = "客户名称")
    private String customerName;

    /**
     * 客户编号
     */
    @Schema(description = "客户编号")
    private String customerBizId;
}
