package com.yd.csf.service.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.csf.service.model.Commission;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class CommissionVO implements Serializable {

    /**
     * 保单来佣业务id
     */
    @Schema(description = "保单来佣业务id")
    private String commissionBizId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 对账公司
     */
    @Schema(description = "对账公司")
    private String reconciliationCompany;

    /**
     * 佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)")
    private Integer commissionPeriod;

    /**
     * 总来佣期数
     */
    @Schema(description = "总来佣期数")
    private Integer totalPeriod;

    /**
     * 来佣名称(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    @Schema(description = "来佣名称(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)")
    private String commissionName;

    /**
     * 来佣类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    @Schema(description = "来佣类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)")
    private String commissionType;

    /**
     * 来佣金额
     */
    @Schema(description = "来佣金额")
    private BigDecimal amount;

    /**
     * 来佣币种
     */
    @Schema(description = "来佣币种")
    private String currency;

    /**
     * 来佣日期
     */
    @Schema(description = "来佣日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commissionDate;

    /**
     * 来佣状态
     */
    @Schema(description = "来佣状态 1=已比对 2=部分来佣")
    private String status;

    /**
     * 通用备注
     */
    @Schema(description = "备注")
    private String remark;

    /**
     * 创建人ID
     */
    @Schema(description = "创建人ID")
    private String creatorId;

    /**
     * 更新人ID
     */
    @Schema(description = "更新人ID")
    private String updaterId;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * 更新时间
     */
    @Schema(description = "更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    private static final long serialVersionUID = 1L;

    /**
     * 对象转封装类
     *
     * @param commission
     * @return
     */
    public static CommissionVO objToVo(Commission commission) {
        if (commission == null) {
            return null;
        }
        CommissionVO commissionVO = new CommissionVO();
        BeanUtils.copyProperties(commission, commissionVO);
        return commissionVO;
    }
}
