package com.yd.csf.feign.fallback.common;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.common.ApiCsfCommonFeignClient;
import com.yd.csf.feign.request.common.ApiCsfCalculateRequest;
import com.yd.csf.feign.response.common.ApiCsfCalculateResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 香港保险服务-公共接口信息Feign降级处理
 */
@Slf4j
@Component
public class ApiCsfCommonFeignFallbackFactory implements FallbackFactory<ApiCsfCommonFeignClient> {
    @Override
    public ApiCsfCommonFeignClient create(Throwable cause) {
        return new ApiCsfCommonFeignClient() {
            @Override
            public Result<List<ApiCsfCalculateResponse>> calculate(ApiCsfCalculateRequest request) {
                return null;
            }
        };
    }
}
