package com.yd.csf.feign.response.appointment;

import com.yd.csf.feign.dto.appointment.ApiAppointmentReferrerLogDto;
import com.yd.csf.feign.dto.appointment.ApiAppointmentUserSignLogDto;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
public class ApiAppointmentLogDetailResponse {

    /**
     * 预约信息日志表主键ID
     */
    private Long id;

    /**
     * 预约信息日志表唯一业务ID
     */
    private String appointmentLogBizId;

    /**
     * 预约信息主表唯一业务ID
     */
    private String appointmentBizId;

    /**
     * 预约编号
     */
    private String appointmentNo;

    /**
     * 关联客户信息表唯一业务ID（冗余字段）
     */
    private String customerBizId;

    /**
     * 关联客户编号（和客户信息表唯一业务ID是一对，唯一，冗余字段）
     */
    private String customerNo;

    /**
     * 关联FNA信息表唯一业务ID（冗余字段）
     */
    private String fnaBizId;

    /**
     * 关联FNA编号（和FNA信息表唯一业务ID是一对，唯一，冗余字段）
     */
    private String fnaNo;

    /**
     * 关联计划书信息表唯一业务ID（冗余字段）
     */
    private String proposalBizId;

    /**
     * 关联计划书编号（和计划书信息表唯一业务ID是一对，唯一，冗余字段）
     */
    private String proposalNo;

    /**
     * 预约状态: 0-暂存 1-待预约, 2-待签署 3-已签署 4-已取消（字典）
     */
    private Integer status;

    /**
     * 申请类型（字典）
     */
    private String applyType;

    /**
     * 到港时间
     */
    private LocalDateTime arrivalTime;

    /**
     * 离港时间
     */
    private LocalDateTime departureTime;

    /**
     * 会面地点（字典）
     */
    private String meetingPoint;

    /**
     * 签单地址
     */
    private String signingAddress;

    /**
     * 客户在港期间联络电话区号
     */
    private String hkMobileCode;

    /**
     * 客户在港期间联络电话
     */
    private String hkMobile;

    /**
     * 是否开户: 0-否, 1-是（字典）
     */
    private Integer isOpenAccount;

    /**
     * 开户行名称
     */
    private String bankName;

    /**
     * 开户行支行（分行）
     */
    private String bankBranchName;

    /**
     * 开户时间段（开始）
     */
    private LocalDateTime openAccountStartTime;

    /**
     * 开户时间段（结束）
     */
    private LocalDateTime openAccountEndTime;

    /**
     * 开户地点
     */
    private String openAccountLocation;

    /**
     * 开户须知
     */
    private String openAccountNotice;

    /**
     * 是否体检: 0-否, 1-是（字典）
     */
    private Integer isTj;

    /**
     * 是否购买过香港保险: 0-否, 1-是（字典）
     */
    private Integer isBuy;

    /**
     * 转保声明选项(字典)
     */
    private String policyTransfer;

    /**
     * 是否有用车服务：0-否, 1-是（字典）
     */
    private Integer isUseCar;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 创建人用户名
     */
    private String creatorName;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 预约-转介人信息日志列表
     */
    private List<ApiAppointmentReferrerLogDto> referrerLogDtoList;

    /**
     * 预约-签单员信息日志列表
     */
    private List<ApiAppointmentUserSignLogDto> userSignLogDtoList;
}
