package com.yd.csf.api.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * SQL模板条件入参参数及参数值对象（通用，用于各种SQL模板计算值入参条件参数值，这边集成大部分SQL模所需的条件参数，SQL模板会去匹配入参sqlTemplateParamDto有符合的就作为条件参数）
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SqlTemplateParamDto {

    /**
     * 保单绑定转介人业务ID（销售业务员，客户端用户表唯一业务ID，也可以单独用作客户端用户ID非绑定保单使用）
     */
    private String brokerBizId;

    /**
     * 获得积分的用户（客户端用户表唯一业务ID）
     */
    private String clientUserBizId;

    /**
     * 保单发佣批次ID
     */
    private String batchBizId;

    /**
     * 保单来佣业务id
     */
    private String commissionBizId;

    /**
     * 基本法-条件类型表唯一业务ID
     */
    private String conditionTypeBizId;

    /**
     * 保单号
     */
    private String policyNo;

    //======计算SQL-产品公告比例入参参数-start======
    /**
     * 保险产品唯一业务ID
     */
    private String productBizId;

    /**
     * 产品代码
     */
    private String productCode;

    /**
     * 供款年期（产品有5年期的有10年期等）(总期数)
     */
    private Integer term;

    /**
     * 期数（数字代表第几年）
     */
    private Integer issueNumber;
    //======计算SQL-产品公告比例入参参数-end======
}
