package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 预计发佣表
 * </p>
 *
 * @author zxm
 * @since 2025-11-17
 */
@Getter
@Setter
@TableName("expected_fortune")
public class ExpectedFortune implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 预计发佣表唯一业务id
     */
    @TableField("expected_fortune_biz_id")
    private String expectedFortuneBizId;

    /**
     * 保单号
     */
    @TableField("policy_no")
    private String policyNo;

    /**
     * 发佣期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @TableField("fortune_period")
    private Integer fortunePeriod;

    /**
     * 发佣总期数
     */
    @TableField("fortune_total_period")
    private Integer fortuneTotalPeriod;

    /**
     * 转介人名称
     */
    @TableField("broker")
    private String broker;

    /**
     * 转介人业务ID
     */
    @TableField("broker_biz_id")
    private String brokerBizId;

    /**
     * 团队名称
     */
    @TableField("team")
    private String team;

    /**
     * 所属团队业务ID
     */
    @TableField("team_biz_id")
    private String teamBizId;

    /**
     * 发佣名称
     */
    @TableField("fortune_name")
    private String fortuneName;

    /**
     * 发佣类型
     */
    @TableField("fortune_type")
    private String fortuneType;

    /**
     * 转介人介绍费占比
     */
    @TableField("broker_ratio")
    private String brokerRatio;

    /**
     * 标准发佣金额
     */
    @TableField("standard_amount")
    private BigDecimal standardAmount;

    /**
     * 实际发佣金额（实际发佣金额 = 标准发佣金额 * 转介人介绍费占比）
     */
    @TableField("amount")
    private BigDecimal amount;

    /**
     * 发佣币种
     */
    @TableField("currency")
    private String currency;

    /**
     * 佣金发放状态 0=待出账 1=可出帐 2=已出账
     */
    @TableField("status")
    private String status;

    /**
     * 是否含税 0=No, 1=Yes
     */
    @TableField("is_tax")
    private Integer isTax;

    /**
     * 应缴税额
     */
    @TableField("tax_amount")
    private BigDecimal taxAmount;

    /**
     * 税后发佣
     */
    @TableField("net_amount")
    private BigDecimal netAmount;

    /**
     * 基本法项目配置表唯一业务ID
     */
    @TableField("rule_item_biz_id")
    private String ruleItemBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
