package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 新单跟进表
 * @TableName policy_follow
 */
@TableName(value ="policy_follow")
@Data
public class PolicyFollow implements Serializable {
    /**
     * id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 新单跟进唯一业务ID
     */
    private String policyBizId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 预约信息主表唯一业务ID
     */
    private String appointmentBizId;

    /**
     * 预约编号
     */
    private String appointmentNo;

    /**
     * 用户业务id
     */
    private String userBizId;

    /**
     * 客户业务id
     */
    private String customerBizId;

    /**
     * 客户名称
     */
    private String customerName;

     /**
     * 递交日期
     */
    private Date submitDate;

    /**
     * 签单日期
     */
    private Date signDate;

    /**
     * 签单人
     */
    private String signer;

    /**
     * 缮发日期
     */
    private Date issueDate;

    /**
     * 生效日期
     */
    private Date effectiveDate;

    /**
     * 续保日期
     */
    private Date renewalDate;

    /**
     * 供款年期
     */
    private Integer paymentTerm;

    /**
     * 期交保费
     */
    private BigDecimal paymentPremium;

    /**
     * 是否预缴: 0-否, 1-是
     */
    private Integer isPrepaid;

    /**
     * 预缴年期
     */
    private Integer prepaidTerm;

    /**
     * 预付额
     */
    private String prepaidAmount;

    /**
     * 折扣后预付额
     */
    private String prepaidAmountAfterDiscount;

    /**
     * 保单截止日期
     */
    private Date policyExpirationDate;

    /**
     * 缴费编号
     */
    private String paymentNumber;

     /**
     * 产品业务id
     */
    private String productBizId;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 产品类别
     */
    private String productCate;

    /**
     * 保险公司
     */
    private String insurer;

    /**
     * 保险公司业务id
     */
    private String insurerBizId;

    /**
     * 对账公司
     */
    private String reconciliationCompany;

    /**
     * 对账公司业务id
     */
    private String reconciliationCompanyBizId;

    /**
     * 新单跟进状态
     */
    private String status;

     /**
     * 下一步跟进状态列表
     */
    private String nextStatusList;

    /**
     * 保單持有人
     */
    private String policyHolder;

    /**
     * 受保人
     */
    private String insured;

    /**
     * 币种
     */
    private String currency;

    /**
     * 首期保费（不含徽费，预缴保费）
     */
    private Object initialPremium;

    /**
     * 寄送方式 1-自提, 2-快递
     */
    private String mailingMethod;

    /**
     * 快递单号
     */
    private String deliveryNo;

    /**
     * 经纪公司签收日期
     */
    private String brokerSignDate;

    /**
     * 保险公司寄出日期
     */
    private String insurerMailingDate;

    /**
     * 客户签收日期
     */
    private String customerSignDate;

    /**
     * 附件列表
     */
    private String attachments;

    /**
     * 备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField()
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}