package com.yd.csf.feign.utils;

import com.alibaba.fastjson.JSON;
import com.yd.csf.feign.dto.AddressDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 公共工具类
 */
public class CommonUtil {

    /**
     * 地址列表转成json串
     * @param addressList
     * @return
     */
    public static String getAddressListJsonStr(List<AddressDto> addressList) {
        return !CollectionUtils.isEmpty(addressList) ? JSON.toJSONString(addressList) : "";
    }

    /**
     * 地址json串转成地址列表
     * @param addressListJson 地址JSON字符串
     * @return 地址列表
     */
    public static List<AddressDto> getAddressList(String addressListJson) {
        if (StringUtils.isEmpty(addressListJson)) {
            return new ArrayList<>();
        }
        try {
            return JSON.parseArray(addressListJson, AddressDto.class);
        } catch (Exception e) {
            // 日志记录异常
            System.err.println("地址JSON解析异常: " + e.getMessage());
            return new ArrayList<>();
        }
    }
}
