package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class CommissionUpdateRequest implements Serializable {
    /**
     * 保单入账业务id
     */
    @Schema(description = "保单入账业务id", requiredMode = Schema.RequiredMode.REQUIRED)
    private String commissionBizId;

    @Schema(description = "应收款类型 R=关联保单应收单 U=非关联保单应收单", requiredMode = Schema.RequiredMode.REQUIRED)
    private String commissionBizType;

    /**
     * 入账检核年月 yyyy-MM
     */
    @Schema(description = "入账检核年月 yyyy-MM")
    private String reconciliationYearMonth;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 对账公司
     */
    @Schema(description = "对账公司")
    private String reconciliationCompany;

    /**
     * 对账公司业务id
     */
    @Schema(description = "对账公司业务id")
    private String reconciliationCompanyBizId;

    /**
     * 入账比对状态
     */
//    @Schema(description = "入账比对状态 1=比对成功 2=比对失败")
//    private String status;

    /**
     * 佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)")
    private Integer commissionPeriod;

    /**
     * 总入账期数
     */
    @Schema(description = "总入账期数")
    private Integer totalPeriod;

    /**
     * 入账项目名称(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    @Schema(description = "入账项目名称(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)")
    private String commissionName;

    /**
     * 入账项目类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    @Schema(description = "入账项目类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)")
    private String commissionType;

    /**
     * 入账金额
     */
    @Schema(description = "入账金额")
    private BigDecimal amount;

    /**
     * 入账币种
     */
    @Schema(description = "入账币种")
    private String currency;

    /**
     * 结算汇率
     */
    @Schema(description = "结算汇率")
    private BigDecimal exchangeRate;

    /**
     * 入账日期
     */
    @Schema(description = "入账日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commissionDate;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;

    private static final long serialVersionUID = 1L;
}
