package com.yd.csf.api.service.impl;

import com.yd.common.enums.CommonEnum;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.csf.api.service.ApiAppointmentLogService;
import com.yd.csf.service.model.Appointment;
import com.yd.csf.service.model.AppointmentLog;
import com.yd.csf.service.service.IAppointmentLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class ApiAppointmentLogServiceImpl implements ApiAppointmentLogService {

    @Autowired
    private IAppointmentLogService iAppointmentLogService;

    /**
     * 保存预约日志信息
     * @param appointment
     * @return
     */
    @Override
    public Result<String> saveAppointmentLog(Appointment appointment) {
        AppointmentLog appointmentLog = new AppointmentLog();
        BeanUtils.copyProperties(appointment,appointmentLog);
        appointmentLog.setAppointmentBizId(appointment.getAppointmentBizId());
        appointmentLog.setAppointmentLogBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_APPOINTMENT_LOG.getCode()));
        iAppointmentLogService.saveOrUpdate(appointmentLog);
        return Result.success(appointmentLog.getAppointmentLogBizId());
    }

}
