package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 保单附加险信息表
 * @TableName policy_additional
 */
@TableName(value ="policy_additional")
@Data
public class PolicyAdditional implements Serializable {
    /**
     *
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 保单附加险信息表唯一业务ID
     */
    private String policyAdditionalBizId;

    /**
     * 新单跟进业务ID
     */
    private String policyBizId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 产品计划信息表唯一业务ID
     */
    private String planBizId;

    /**
     * 产品上架信息表唯一业务ID
     */
    private String productLaunchBizId;

    /**
     * 品上架信息表名称
     */
    private String productLaunchName;

    /**
     * 付款频率（字典）
     */
    private String paymentFrequency;

    /**
     * 保障年期
     */
    private String guaranteePeriod;

    /**
     * 保单币种
     */
    private String policyCurrency;

    /**
     * 供款期数
     */
    private String issueNumber;

    /**
     * 保费
     */
    private BigDecimal eachIssuePremium;

    /**
     * 保额（重疾）
     */
    private BigDecimal sumInsured;

    /**
     * 保障级别
     */
    private String protectionLevel;

    /**
     * 保障地区（字典）
     */
    private String guaranteeRegion;

    /**
     * 自付额（字典）
     */
    private String deductibles;

    /**
     * 附加保障（json串）
     */
    private String additionalSafeguards;

    /**
     * 保单征费
     */
    private BigDecimal policyLevy;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}