package com.yd.csf.api.controller;

import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.enums.CommonEnum;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.csf.api.dto.PolicyExcelDTO;
import com.yd.csf.api.dto.PolicyFollowDTO;
import com.yd.csf.api.listener.PolicyDataListener;
import com.yd.csf.service.common.ErrorCode;
import com.yd.csf.service.dto.PolicyFollowQueryRequest;
import com.yd.csf.service.dto.PolicyFollowUpdateRequest;
import com.yd.csf.service.model.Policy;
import com.yd.csf.service.model.PolicyBroker;
import com.yd.csf.service.model.PolicyFollow;
import com.yd.csf.service.service.PolicyBrokerService;
import com.yd.csf.service.service.PolicyFollowService;
import com.yd.csf.service.service.PolicyService;
import com.yd.csf.service.vo.PolicyFollowVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * customer接口
 *
 * @author jianan
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/policy_follow")
@Tag(name = "新单跟进接口")
public class ApiPolicyFollowController {

    private static final Logger log = LoggerFactory.getLogger(ApiPolicyFollowController.class);

    @Resource
    private PolicyFollowService policyFollowService;
    @Resource
    private PolicyService policyService;
    @Resource
    private PolicyBrokerService policyBrokerService;


    @Resource
    private PolicyDataListener policyDataListener;


    @PostMapping("/upload/excel")
    @Transactional(rollbackFor = Exception.class)
    public Result<Boolean> uploadExcel(@RequestParam("file") MultipartFile file) throws IOException {
        EasyExcel.read(file.getInputStream(), PolicyExcelDTO.class, policyDataListener).sheet("保单").doRead();

        List<PolicyExcelDTO> dtoList = policyDataListener.getList();

        // 转换为PolicyFollow对象
        List<PolicyFollowDTO> list = convertToObj(dtoList);

        List<PolicyFollow> policyFollowList = new ArrayList<>();
        List<Policy> policyList = new ArrayList<>();
        List<PolicyBroker> policyBrokerList = new ArrayList<>();
        for (PolicyFollowDTO policyFollow : list) {
            policyFollowList.add(policyFollow.getPolicyFollow());
            policyBrokerList.addAll(policyFollow.getBrokerList());
            policyList.add(policyFollow.getPolicy());
        }

        policyFollowService.saveBatch(policyFollowList);
        policyService.saveBatch(policyList);
        policyBrokerService.saveBatch(policyBrokerList);

        return Result.success(true);
    }

    private List<PolicyFollowDTO> convertToObj(List<PolicyExcelDTO> list) {
        List<PolicyFollowDTO> policyFollowDTOList = new ArrayList<>();

        for (PolicyExcelDTO policyExcelDTO : list) {
            String policyNo = policyExcelDTO.getPolicyNo();
            // 生成新单编号
            String policyBizId = RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_POLICY.getCode());
            // 转换为PolicyFollow对象
            PolicyFollow policyFollow = new PolicyFollow();
            BeanUtils.copyProperties(policyExcelDTO, policyFollow);
            policyFollow.setPolicyBizId(policyBizId);

            // 转换为Policy对象
            Policy policy = new Policy();
            BeanUtils.copyProperties(policyExcelDTO, policy);
            policy.setPolicyBizId(policyBizId);

            // 转换为PolicyBroker对象
            List<PolicyBroker> policyBrokerList = new ArrayList<>();
            if (StringUtils.isNotBlank(policyExcelDTO.getBrokerName1())) {
                policyBrokerList.add(getPolicyBroker(policyExcelDTO.getBrokerName1(), policyExcelDTO.getTeam1(), policyBizId, policyNo));
            }
            if (StringUtils.isNotBlank(policyExcelDTO.getBrokerName2())) {
                policyBrokerList.add(getPolicyBroker(policyExcelDTO.getBrokerName2(), policyExcelDTO.getTeam2(), policyBizId, policyNo));
            }
            if (StringUtils.isNotBlank(policyExcelDTO.getBrokerName3())) {
                policyBrokerList.add(getPolicyBroker(policyExcelDTO.getBrokerName3(), policyExcelDTO.getTeam3(), policyBizId, policyNo));
            }
            if (StringUtils.isNotBlank(policyExcelDTO.getBrokerName4())) {
                policyBrokerList.add(getPolicyBroker(policyExcelDTO.getBrokerName4(), policyExcelDTO.getTeam4(), policyBizId, policyNo));
            }
            if (StringUtils.isNotBlank(policyExcelDTO.getBrokerName5())) {
                policyBrokerList.add(getPolicyBroker(policyExcelDTO.getBrokerName5(), policyExcelDTO.getTeam5(), policyBizId, policyNo));
            }

            // 转换为PolicyFollowDTO对象
            PolicyFollowDTO policyFollowDTO = new PolicyFollowDTO();
            policyFollowDTO.setPolicyFollow(policyFollow);
            policyFollowDTO.setPolicy(policy);
            policyFollowDTO.setBrokerList(policyBrokerList);
            policyFollowDTOList.add(policyFollowDTO);
        }
        return policyFollowDTOList;
    }

    private PolicyBroker getPolicyBroker(String brokerName, String team, String policyBizId, String policyNo) {
        PolicyBroker policyBroker = new PolicyBroker();
        policyBroker.setPolicyBizId(policyBizId);
        policyBroker.setPolicyNo(policyNo);
        policyBroker.setBrokerName(brokerName);
        policyBroker.setTeam(team);
        return policyBroker;
    }

    /**
     * 创建新单跟进
     *
     * @param customerAddRequest
     * @param request
     * @return
     */
//    @Operation(summary = "创建新单跟进")
//    @PostMapping("/add")
//    @Transactional(rollbackFor = Exception.class)
//    public Result<Map<String, Object>> addCustomer(@RequestBody CustomerAddRequest customerAddRequest, HttpServletRequest request) {
//        if (customerAddRequest == null) {
//            return Result.fail(ErrorCode.PARAMS_ERROR.getCode(), ErrorCode.PARAMS_ERROR.getMessage());
//        }
//        return Result.success(policyFollowService.addCustomer(customerAddRequest));
//    }

    /**
     * 删除fna
     *
     * @param deleteRequest
     * @param request
     * @return
     */
//    @PostMapping("/delete")
//    public Result<Boolean> deleteFna(@RequestBody DeleteRequest deleteRequest, HttpServletRequest request) {
//        if (deleteRequest == null || deleteRequest.getId() <= 0) {
//            throw new BusinessException(ErrorCode.PARAMS_ERROR);
//        }
//        User user = userService.getLoginUser(request);
//        long id = deleteRequest.getId();
//        // 判断是否存在
//        Customer oldFna = policyFollowService.getById(id);
//        ThrowUtils.throwIf(oldFna == null, ErrorCode.NOT_FOUND_ERROR);
//        // 仅本人或管理员可删除
//        if (!oldFna.getUserId().equals(user.getId()) && !userService.isAdmin(request)) {
//            throw new BusinessException(ErrorCode.NO_AUTH_ERROR);
//        }
//        // 操作数据库
//        boolean result = policyFollowService.removeById(id);
//        ThrowUtils.throwIf(!result, ErrorCode.OPERATION_ERROR);
//        return Result.success(true);
//    }

    /**
     * 更新新单跟进
     *
     * @param policyFollowUpdateRequest
     * @return
     */
    @PostMapping("/update")
    @Operation(summary = "更新新单跟进信息")
    public Result<Boolean> updatePolicyFollow(@RequestBody PolicyFollowUpdateRequest policyFollowUpdateRequest) {
        if (policyFollowUpdateRequest == null || policyFollowUpdateRequest.getPolicyBizId() == null) {
            return Result.fail(ErrorCode.PARAMS_ERROR.getCode(), ErrorCode.PARAMS_ERROR.getMessage());
        }
        return Result.success(policyFollowService.updatePolicyFollow(policyFollowUpdateRequest));
    }

    /**
     * 根据 policyBizId 获取新单跟进（封装类）
     *
     * @param policyBizId
     * @return
     */
    @GetMapping("/get/vo")
    @Operation(summary = "根据 policyBizId 获取新单跟进详情")
    public Result<PolicyFollowVO> getPolicyFollowByPolicyBizId(@RequestParam("policyBizId") String policyBizId, HttpServletRequest request) {
        if (policyBizId == null) {
            return Result.fail(ErrorCode.PARAMS_ERROR.getCode(), ErrorCode.PARAMS_ERROR.getMessage());
        }
        // 查询数据库
        PolicyFollow policyFollow = policyFollowService.getByPolicyBizId(policyBizId);
        if (policyFollow == null) {
            return Result.fail(ErrorCode.NOT_FOUND_ERROR.getCode(), ErrorCode.NOT_FOUND_ERROR.getMessage());
        }

        // 获取封装类
        return Result.success(policyFollowService.getPolicyFollowVO(policyFollow));
    }

    /**
     * 分页获取新单跟进列表（仅管理员可用）
     *
     * @param fnaQueryRequest
     * @return
     */
//    @PostMapping("/list/page")
//    public Result<Page<Customer>> listFnaByPage(@RequestBody FnaQueryRequest fnaQueryRequest) {
//        long current = fnaQueryRequest.getPageNo();
//        long size = fnaQueryRequest.getPageSize();
//        // 查询数据库
//        Page<Customer> fnaPage = policyFollowService.page(new Page<>(current, size),
//                policyFollowService.getQueryWrapper(fnaQueryRequest));
//        return Result.success(fnaPage);
//    }

    /**
     * 分页获取新单跟进列表（VO）
     *
     * @param policyFollowQueryRequest
     * @param request
     * @return
     */
    @PostMapping("/list/page/vo")
    @Operation(summary = "分页获取新单跟进列表")
    public Result<Page<PolicyFollowVO>> listPolicyFollowByPage(@RequestBody PolicyFollowQueryRequest policyFollowQueryRequest,
                                                         HttpServletRequest request) {
        long current = policyFollowQueryRequest.getPageNo();
        long size = policyFollowQueryRequest.getPageSize();

        // 查询数据库
        Page<PolicyFollow> policyFollowPage = policyFollowService.page(new Page<>(current, size),
                policyFollowService.getQueryWrapper(policyFollowQueryRequest));
        // 获取封装类
        return Result.success(policyFollowService.getPolicyFollowVOPage(policyFollowPage));
    }

}
