package com.yd.csf.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.feign.dto.appointment.ApiAppointmentInfoDto;
import com.yd.csf.feign.request.appointment.*;
import com.yd.csf.feign.response.appointment.ApiAppointmentDetailResponse;
import com.yd.csf.feign.response.appointment.ApiAppointmentPageResponse;
import com.yd.csf.service.model.Appointment;

public interface ApiAppointmentService {
    Result<IPage<ApiAppointmentPageResponse>> page(ApiAppointmentPageRequest request);

    Result<ApiAppointmentDetailResponse> detail(String appointmentBizId);

    Result<ApiAppointmentInfoDto> mainDetail(String appointmentBizId);

    Result add(ApiAppointmentAddRequest request);

    Result addStorage(ApiAppointmentAddStorageRequest request);

    Result edit(ApiAppointmentEditRequest request);

    Result editConfirmTime(ApiAppointmentEditConfirmTimeRequest request);

    Result singleEdit(ApiAppointmentInfoDto apiAppointmentInfoDto);

    Result editFna(ApiAppointmentEditFnaRequest request);

    Result removeFna(ApiAppointmentRemoveFnaRequest request);

    Result editProposal(ApiAppointmentEditProposalRequest request);

    Result removeProposal(ApiAppointmentRemoveProposalRequest request);

    Result<Appointment> checkAppointmentIsExist(String appointmentBizId);
}
