package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.model.AppointmentUserSignLog;
import com.yd.csf.service.dao.AppointmentUserSignLogMapper;
import com.yd.csf.service.service.IAppointmentUserSignLogService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 预约-签单员信息日志表（快照表） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-12-15
 */
@Service
public class AppointmentUserSignLogServiceImpl extends ServiceImpl<AppointmentUserSignLogMapper, AppointmentUserSignLog> implements IAppointmentUserSignLogService {

    @Override
    public List<AppointmentUserSignLog> queryList(String appointmentLogBizId) {
        return this.baseMapper.selectList(new LambdaQueryWrapper<AppointmentUserSignLog>()
                .eq(AppointmentUserSignLog::getAppointmentLogBizId,appointmentLogBizId));
    }

}
