package com.yd.csf.feign.fallback.beneficiary;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.beneficiary.ApiBeneficiaryFeignClient;
import com.yd.csf.feign.dto.appointment.ApiBeneficiaryInfoDto;
import com.yd.csf.feign.dto.appointment.ApiInsurantInfoDto;
import com.yd.csf.feign.request.beneficiary.ApiBeneficiaryPageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 香港保险服务-受益人信息Feign降级处理
 */
@Slf4j
@Component
public class ApiBeneficiaryFeignFallbackFactory implements FallbackFactory<ApiBeneficiaryFeignClient> {
    @Override
    public ApiBeneficiaryFeignClient create(Throwable cause) {
        return new ApiBeneficiaryFeignClient() {
            @Override
            public Result page(ApiBeneficiaryPageRequest request) {
                return null;
            }

            @Override
            public Result<List<ApiBeneficiaryInfoDto>> list(String appointmentBizId) {
                return null;
            }

            @Override
            public Result<ApiBeneficiaryInfoDto> detail(String beneficiaryBizId) {
                return null;
            }

            @Override
            public Result add(ApiBeneficiaryInfoDto apiBeneficiaryInfoDto) {
                return null;
            }

            @Override
            public Result edit(ApiBeneficiaryInfoDto apiBeneficiaryInfoDto) {
                return null;
            }

            @Override
            public Result del(String beneficiaryBizId) {
                return null;
            }
        };
    }
}
