package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 查询commission请求
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CommissionQueryRequest extends PageDto implements Serializable {

    /**
     * 来佣状态
     */
    @Schema(description = "来佣状态 '1'-'已比对','2'-'部分来佣', 字典值: csf_commission_status")
    private String status;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 对账公司
     */
    @Schema(description = "对账公司")
    private String reconciliationCompany;

    /**
     * 来佣日期开始
     */
    @Schema(description = "来佣日期开始", example = "2023-01-01",format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commissionDateStart;

    /**
     * 来佣日期结束
     */
    @Schema(description = "来佣日期结束", example = "2023-01-01",format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commissionDateEnd;

    private static final long serialVersionUID = 1L;
}