package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 查询customer请求
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PolicyFollowQueryRequest extends PageDto implements Serializable {

    /**
     * 新单状态
     */
    @Schema(description = "新单状态 'CHECKING'-'审核中','UNDERWRITING'-'承保中','FINISHED'-'已完成','DECLINED'-'已拒绝','CANCELLED'-'已取消', 字典值: csf_policy_follow_status")
    private String status;

    /**
     * 新单编号
     */
    @Schema(description = "新单编号")
    private String policyBizId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 客户名称
     */
    @Schema(description = "客户名称")
    private String customerName;

    /**
     * 客户编号
     */
    @Schema(description = "客户编号")
    private String customerBizId;

    /**
     * 保险公司
     */
    @Schema(description = "保险公司")
    private String insurer;

    /**
     * 产品名称
     */
    @Schema(description = "产品名称")
    private String productName;

    /**
     * 签单日期开始
     */
    @Schema(description = "签单日期开始", example = "2023-01-01 00:00:00",format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date signDateStart;

    /**
     * 签单日期结束
     */
    @Schema(description = "签单日期结束", example = "2023-01-01 23:59:59",format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date signDateEnd;


    private static final long serialVersionUID = 1L;
}