package com.yd.csf.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.csf.service.common.ErrorCode;
import com.yd.csf.service.dao.FnaMapper;
import com.yd.csf.service.dto.DeleteFnaRequest;
import com.yd.csf.service.dto.FnaAddRequest;
import com.yd.csf.service.dto.FnaQueryRequest;
import com.yd.csf.service.model.Fna;
import com.yd.csf.service.service.FnaService;
import com.yd.csf.service.vo.FnaVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * fna服务实现
 *
 */
@Service
@Slf4j
public class FnaServiceImpl extends ServiceImpl<FnaMapper, Fna> implements FnaService {

//    @Resource
//    private UserService userService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Map<String, Object> addFna(FnaAddRequest fnaAddRequest) {
        Fna fna = new Fna();
        BeanUtils.copyProperties(fnaAddRequest, fna);

        // 获取Security上下文当前用户的登录信息
//        AuthUserDto authUserDto = SecurityUtil.getCurrentLoginUser();
//        String userBizId = authUserDto.getUserBizId();

        String userBizId = "user_dMnkKPIwemvY0zhk";

        fna.setUserBizId(userBizId);
        fna.setFnaBizId(RandomStringGenerator.generateBizId16("fna"));

        fna.setCreatorId(userBizId);
        fna.setUpdaterId(userBizId);
        fna.setStatus("UNCOMPLETED");

        Date date = new Date();
        fna.setCreateTime(date);
        fna.setUpdateTime(date);
        // 写入数据库
        boolean result = this.save(fna);

        // 更新 fna_no
//        Fna updateFna = new Fna();
//        updateFna.setId(fna.getId());
//        updateFna.setFnaNo(fna.getId());
//        fnaService.updateById(updateFna);

        // 返回新写入的数据 id
        String fnaBizId = fna.getFnaBizId();
        // 组装返回
        Map<String, Object> map = new HashMap<>();
        map.put("fnaBizId", fnaBizId);
        return map;
    }

    /**
     * 获取查询条件
     *
     * @param fnaQueryRequest
     * @return
     */
    @Override
    public QueryWrapper<Fna> getQueryWrapper(FnaQueryRequest fnaQueryRequest) {
        QueryWrapper<Fna> queryWrapper = new QueryWrapper<>();
        if (fnaQueryRequest == null) {
            return queryWrapper;
        }
        String customerName = fnaQueryRequest.getCustomerName();
        String appointmentNo = fnaQueryRequest.getAppointmentNo();
        String policyId = fnaQueryRequest.getPolicyId();
        String policyNo = fnaQueryRequest.getPolicyNo();
        LocalDateTime startTime = fnaQueryRequest.getStartTime();
        LocalDateTime endTime = fnaQueryRequest.getEndTime();
        String fnaNo = fnaQueryRequest.getFnaNo();
        String status = fnaQueryRequest.getStatus();
        // 流程编号
        queryWrapper.like(StringUtils.isNotBlank(fnaNo), "fna_no", fnaNo);
        // 状态
        queryWrapper.eq(StringUtils.isNotBlank(status), "status", status);
        // 创建时间开始
        queryWrapper.ge(ObjectUtils.isNotEmpty(startTime), "create_time", startTime);
        // 创建时间结束
        queryWrapper.le(ObjectUtils.isNotEmpty(endTime), "create_time", endTime);
        // 客户姓名
        queryWrapper.like(StringUtils.isNotBlank(customerName), "customer_name", customerName);
        // 预约编号
        queryWrapper.like(StringUtils.isNotBlank(appointmentNo), "appointment_no", appointmentNo);
        // 新单编号
        queryWrapper.like(StringUtils.isNotBlank(policyId), "policy_id", policyId);
        // 保单号
        queryWrapper.like(StringUtils.isNotBlank(policyNo), "policy_no", policyNo);

        // 排序规则
        queryWrapper.orderByDesc("id");
        return queryWrapper;
    }

    /**
     * 获取fna封装
     *
     * @param fna
     * @return
     */
    @Override
    public FnaVO getFnaVO(Fna fna) {
        // 对象转封装类
        FnaVO fnaVO = FnaVO.objToVo(fna);

        // region 可选

        // 1. 关联查询用户信息
//        Long userId = fna.getUserId();
//        User user = null;
//        if (userId != null && userId > 0) {
//            user = userService.getById(userId);
//        }
//        UserVO userVO = userService.getUserVO(user);
//        fnaVO.setUser(userVO);
        // 2. 已登录，获取用户点赞、收藏状态
        long fnaId = fna.getId();
//        User loginUser = userService.getLoginUserPermitNull(request);

        // endregion

        return fnaVO;
    }

    /**
     * 分页获取fna封装
     *
     * @param fnaPage
     * @return
     */
    @Override
    public Page<FnaVO> getFnaVOPage(Page<Fna> fnaPage) {
        List<Fna> fnaList = fnaPage.getRecords();
        Page<FnaVO> fnaVOPage = new Page<>(fnaPage.getCurrent(), fnaPage.getSize(), fnaPage.getTotal());
        if (CollUtil.isEmpty(fnaList)) {
            return fnaVOPage;
        }
        // 对象列表 => 封装对象列表
        List<FnaVO> fnaVOList = fnaList.stream().map(FnaVO::objToVo).collect(Collectors.toList());

        // region 可选
        // 1. 关联查询用户信息
//        Set<Long> userIdSet = fnaList.stream().map(Fna::getUserId).collect(Collectors.toSet());
//        Map<Long, List<User>> userIdUserListMap = userService.listByIds(userIdSet).stream()
//                .collect(Collectors.groupingBy(User::getId));

        // 2. 已登录，获取用户点赞、收藏状态
        Map<Long, Boolean> fnaIdHasThumbMap = new HashMap<>();
        Map<Long, Boolean> fnaIdHasFavourMap = new HashMap<>();
//        User loginUser = userService.getLoginUserPermitNull(request);


        // 填充信息
//        fnaVOList.forEach(fnaVO -> {
//            Long userId = fnaVO.getUserId();
//            User user = null;
//            if (userIdUserListMap.containsKey(userId)) {
//                user = userIdUserListMap.get(userId).get(0);
//            }
//            fnaVO.setUser(userService.getUserVO(user));
//            fnaVO.setHasThumb(fnaIdHasThumbMap.getOrDefault(fnaVO.getId(), false));
//            fnaVO.setHasFavour(fnaIdHasFavourMap.getOrDefault(fnaVO.getId(), false));
//        });
        // endregion

        fnaVOPage.setRecords(fnaVOList);
        return fnaVOPage;
    }

    @Override
    public Fna getByBizId(String fnaBizId) {
        QueryWrapper<Fna> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fna_biz_id", fnaBizId);
        return baseMapper.selectOne(queryWrapper);
    }

    @Override
    public boolean updateByBizId(Fna fna) {
        UpdateWrapper<Fna> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("fna_biz_id", fna.getFnaBizId());
        return baseMapper.update(fna, updateWrapper) > 0;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean deleteFna(DeleteFnaRequest deleteRequest) {
        String fnaBizId = deleteRequest.getFnaBizId();
        // 判断是否存在
        Fna oldFna = this.getByBizId(fnaBizId);
        if (oldFna == null) {
            throw new BusinessException(ErrorCode.NOT_FOUND_ERROR.getCode(), ErrorCode.NOT_FOUND_ERROR.getMessage());
        }
        // 操作数据库
        boolean result = this.removeById(oldFna.getId());
        if (!result) {
            throw new BusinessException(ErrorCode.OPERATION_ERROR.getCode(), ErrorCode.OPERATION_ERROR.getMessage());
        }
        return result;
    }

}
