package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.feign.request.commissionsqltemplate.ApiCommissionSqlTemplatePageRequest;
import com.yd.csf.feign.response.commissionsqltemplate.ApiCommissionSqlTemplatePageResponse;
import com.yd.csf.service.dto.CommissionSqlTemplateDto;
import com.yd.csf.service.model.CommissionSqlTemplate;
import com.yd.csf.service.dao.CommissionSqlTemplateMapper;
import com.yd.csf.service.model.ConditionType;
import com.yd.csf.service.service.ICommissionSqlTemplateService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * SQL模板表 - 存储所有佣金计算相关的动态SQL模板，支持灵活配置和参数化查询，实现业务逻辑与代码解耦 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-10-15
 */
@Service
public class CommissionSqlTemplateServiceImpl extends ServiceImpl<CommissionSqlTemplateMapper, CommissionSqlTemplate> implements ICommissionSqlTemplateService {

    @Override
    public IPage<ApiCommissionSqlTemplatePageResponse> page(Page<ApiCommissionSqlTemplatePageResponse> page,
                                                            ApiCommissionSqlTemplatePageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<CommissionSqlTemplate> queryList(CommissionSqlTemplateDto dto) {
        List<CommissionSqlTemplate> list = baseMapper.selectList(new LambdaQueryWrapper<CommissionSqlTemplate>()
                .in(!CollectionUtils.isEmpty(dto.getSqlTemplateBizIdList()),CommissionSqlTemplate::getSqlTemplateBizId,dto.getSqlTemplateBizIdList())
        );
        return list;
    }

    /**
     * 查询单个对象
     * @param sqlTemplateBizId
     * @return
     */
    @Override
    public CommissionSqlTemplate queryOne(String sqlTemplateBizId) {
        return this.getOne(new LambdaQueryWrapper<CommissionSqlTemplate>().eq(CommissionSqlTemplate::getSqlTemplateBizId,sqlTemplateBizId));
    }
}
