package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiAdditionalService;
import com.yd.csf.feign.client.additional.ApiAdditionalFeignClient;
import com.yd.csf.feign.dto.appointment.ApiProductPlanAdditionalInfoDto;
import com.yd.csf.feign.request.additional.ApiAdditionalPageRequest;
import com.yd.csf.feign.response.additional.ApiAdditionalPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 预约-产品计划-附加险信息
 *
 * @author zxm
 * @since 2025-09-01
 */
@RestController
@RequestMapping("/additional")
@Validated
public class ApiAdditionalController implements ApiAdditionalFeignClient {

    @Autowired
    private ApiAdditionalService apiAdditionalService;

    /**
     * 附加险分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiAdditionalPageResponse>> page(ApiAdditionalPageRequest request) {
        return apiAdditionalService.page(request);
    }

    /**
     * 新增单个附加险信息
     * @param apiProductPlanAdditionalInfoDto
     * @return
     */
    @Override
    public Result add(ApiProductPlanAdditionalInfoDto apiProductPlanAdditionalInfoDto) {
        return apiAdditionalService.add(apiProductPlanAdditionalInfoDto);
    }

    /**
     * 编辑单个附加险信息
     * @param apiProductPlanAdditionalInfoDto
     * @return
     */
    @Override
    public Result edit(ApiProductPlanAdditionalInfoDto apiProductPlanAdditionalInfoDto) {
        return apiAdditionalService.edit(apiProductPlanAdditionalInfoDto);
    }

    /**
     * 单个附加险信息详情
     * @param additionalBizId
     * @return
     */
    @Override
    public Result<ApiProductPlanAdditionalInfoDto> detail(String additionalBizId) {
        return apiAdditionalService.detail(additionalBizId);
    }

    /**
     * 删除单个附加险信息
     * @param additionalBizId
     * @return
     */
    @Override
    public Result del(String additionalBizId) {
        return apiAdditionalService.del(additionalBizId);
    }
}
