package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Data
public class LiquidAssets {
    /**
     * 累积流动资产
     */
    @Schema(description = "您现时的累积流动资产约有多少?")
    private String liquidAssets;

    /**
     * 流动资产种类
     */
    @Schema(description = "流动资产种类，多选逗号隔开 字典值：csf_liquid_asset_type")
    private String liquidAssetType;

    /**
     * 其他流动资产的说明
     */
    @Schema(description = "其他流动资产的说明")
    private String otherLiquidAsset;
}
