package com.yd.csf.feign.request.expectedfortune;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class ExpectedFortuneUpdateRequest {
    /**
     * 预计发佣业务id
     */
    @Schema(description = "预计发佣业务id")
    private String expectedFortuneBizId;

    /**
     * 出账状态
     */
    @Schema(description = "出账状态 0=待出账 1=可出帐 2=完成出账 3=部分出账 4=保留 5=已失效, 字典值: csf_fortune_status")
    private String status;

    /**
     * 当前出账金额
     */
    @Schema(description = "当前出账金额")
    private BigDecimal currentPaymentAmount;

    /**
     * 币种
     */
    @Schema(description = "币种")
    private String currency;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;
}
