package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class PolicyFollowUpdateDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 新单编号
     */
    @Schema(description = "新单编号", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policyBizId;

    /**
     * 客户名称
     */
    @Schema(description = "客户名称")
    private String customerName;

    /**
     * 客户编号
     */
    @Schema(description = "客户编号")
    private String customerBizId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 签单日期
     */
    @Schema(description = "签单日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date signDate;

    /**
     * 签单员列表
     */
    @Schema(description = "签单员列表")
    private List<PolicySigner> signerList;

     /**
     * 冷静期天数
     */
    @Schema(description = "冷静期天数")
    private Integer coolingOffDays;

    /**
     * 冷静期结束日期
     */
    @Schema(description = "冷静期结束日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date coolingOffEndDate;

    /**
     * 生效日期
     */
    @Schema(description = "生效日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date effectiveDate;

    /**
     * 续保日期
     */
    @Schema(description = "续保日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date renewalDate;

    /**
     * 供款年期
     */
    @Schema(description = "供款年期")
    private Integer paymentTerm;

    /**
     * 期交保费
     */
    @Schema(description = "期交保费")
    private BigDecimal paymentPremium;

    /**
     * 是否预缴: 0-否, 1-是
     */
    @Schema(description = "是否预缴: 0-否, 1-是")
    private Integer isPrepaid;

    /**
     * 预缴年期
     */
    @Schema(description = "预缴年期")
    private Integer prepaidTerm;

    /**
     * 产品业务id
     */
    @Schema(description = "产品业务id")
    private String productBizId;

    /**
     * 产品名称
     */
    @Schema(description = "产品名称")
    private String productName;

    /**
     * 产品类别
     */
    @Schema(description = "产品类别")
    private String productCate;

    /**
     * 保险公司
     */
    @Schema(description = "保险公司")
    private String insurer;

    /**
     * 保险公司业务id
     */
    @Schema(description = "保险公司业务id")
    private String insurerBizId;

    /**
     * 对账公司
     */
    @Schema(description = "对账公司")
    private String reconciliationCompany;

    /**
     * 对账公司业务id
     */
    @Schema(description = "对账公司业务id")
    private String reconciliationCompanyBizId;

    /**
     * 保單持有人
     */
    @Schema(description = "保單持有人")
    private String policyHolder;

    /**
     * 受保人
     */
    @Schema(description = "受保人")
    private String insured;

    /**
     * 币种
     */
    @Schema(description = "币种")
    private String currency;

    /**
     * 首期保费（不含徽费，预缴保费）
     */
    @Schema(description = "首期保费（不含徽费，预缴保费）")
    private Object initialPremium;

     /**
     * 保单征费
     */
    @Schema(description = "保单征费")
    private String policyLevy;

    /**
     * 首期已交保费
     */
    @Schema(description = "首期已交保费")
    private String initialPremiumPaid;

    /**
     * 首期待交保费
     */
    @Schema(description = "首期待交保费")
    private String initialPremiumDue;

    /**
     * 最晚缴费日期
     */
    @Schema(description = "最晚缴费日期 格式: yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date latestPaymentDate;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;
}
