package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.model.RuleConditionConfig;
import com.yd.csf.service.dao.RuleConditionConfigMapper;
import com.yd.csf.service.service.IRuleConditionConfigService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 规则条件配置表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-10-15
 */
@Service
public class RuleConditionConfigServiceImpl extends ServiceImpl<RuleConditionConfigMapper, RuleConditionConfig> implements IRuleConditionConfigService {

    /**
     * 查询单个对象
     * @param conditionBizId
     * @return
     */
    @Override
    public RuleConditionConfig queryOne(String conditionBizId) {
        return this.getOne(new LambdaQueryWrapper<RuleConditionConfig>().eq(RuleConditionConfig::getConditionBizId,conditionBizId));
    }

}
