package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiConditionTypeService;
import com.yd.csf.feign.client.conditiontype.ApiConditionTypeFeignClient;
import com.yd.csf.feign.request.conditiontype.ApiConditionTypeAddRequest;
import com.yd.csf.feign.request.conditiontype.ApiConditionTypeEditRequest;
import com.yd.csf.feign.request.conditiontype.ApiConditionTypePageRequest;
import com.yd.csf.feign.response.conditiontype.ApiConditionTypeDetailResponse;
import com.yd.csf.feign.response.conditiontype.ApiConditionTypePageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 条件类型信息
 *
 * @author zxm
 * @since 2025-10-20
 */
@RestController
@RequestMapping("/conditionType")
@Validated
public class ApiConditionTypeController implements ApiConditionTypeFeignClient {

    @Autowired
    private ApiConditionTypeService apiConditionTypeService;

    /**
     * 分页查询-条件类型信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiConditionTypePageResponse>> page(ApiConditionTypePageRequest request) {
        return apiConditionTypeService.page(request);
    }

    /**
     * 详情-条件类型信息
     * @param conditionTypeBizId
     * @return
     */
    @Override
    public Result<ApiConditionTypeDetailResponse> detail(String conditionTypeBizId) {
        return apiConditionTypeService.detail(conditionTypeBizId);
    }

    /**
     * 添加-条件类型信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiConditionTypeAddRequest request) {
        return apiConditionTypeService.add(request);
    }

    /**
     * 编辑-条件类型信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiConditionTypeEditRequest request) {
        return apiConditionTypeService.edit(request);
    }

    /**
     * 删除-条件类型信息 TODO
     * @param conditionTypeBizId
     * @return
     */
    @Override
    public Result del(String conditionTypeBizId) {
        return apiConditionTypeService.del(conditionTypeBizId);
    }
}
