package com.yd.csf.feign.fallback.commissionruleconfig;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.commissionruleconfig.ApiCommissionRuleConfigFeignClient;
import com.yd.csf.feign.request.commissionruleconfig.ApiCommissionRuleConfigAddRequest;
import com.yd.csf.feign.request.commissionruleconfig.ApiCommissionRuleConfigEditRequest;
import com.yd.csf.feign.request.commissionruleconfig.ApiCommissionRuleConfigPageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 香港保险服务-基本法配置信息Feign降级处理
 */
@Slf4j
@Component
public class ApiCommissionRuleConfigFeignFallbackFactory implements FallbackFactory<ApiCommissionRuleConfigFeignClient> {
    @Override
    public ApiCommissionRuleConfigFeignClient create(Throwable cause) {
        return new ApiCommissionRuleConfigFeignClient() {
            @Override
            public Result page(ApiCommissionRuleConfigPageRequest request) {
                return null;
            }

            @Override
            public Result detail(String ruleBizId) {
                return null;
            }

            @Override
            public Result add(ApiCommissionRuleConfigAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiCommissionRuleConfigEditRequest request) {
                return null;
            }

            @Override
            public Result del(String ruleBizId) {
                return null;
            }
        };
    }
}
