package com.yd.csf.feign.request.conditionconfig;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@Data
public class ApiConditionConfigEditRequest {

    /**
     * 条件配置表唯一业务ID
     */
    @NotBlank(message = "条件配置表唯一业务ID不能为空")
    private String conditionBizId;

    /**
     * 条件类型表唯一业务ID
     */
    @NotBlank(message = "条件类型表唯一业务ID不能为空")
    private String conditionTypeBizId;

    /**
     * 条件名称
     */
    @NotBlank(message = "条件名称不能为空")
    private String name;

    /**
     * 条件描述
     */
    private String description;

    /**
     * 最小值（在范围条件中表示最小值）
     */
    private BigDecimal minValue;

    /**
     * 最大值（在范围条件中表示最大值）
     */
    private BigDecimal maxValue;

    /**
     * 是否包含最小值（是否包含最小值，1表示包含，0表示不包含）
     */
    private Integer includeMin;

    /**
     * 是否包含最大值（是否包含最大值，1表示包含，0表示不包含）
     */
    private Integer includeMax;

    /**
     * 条件值（范围内的值，比例值）
     */
    private String conditionalValue;

    /**
     * 优先级（数字越小优先级越高）
     */
    private Integer priority;

    /**
     * 显示顺序
     */
    private Integer displayOrder;

    /**
     * 状态(0:停用 1:启用)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;
}
