package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 业务员积分任务表 - 定时跑批业务员绑定的基本法计算点，算出当前业务员所得的积分（一级管理奖、二级管理奖、辅导津贴奖、终身推荐奖等月末计算，季度结算等）
 * </p>
 *
 * @author zxm
 * @since 2025-10-15
 */
@Getter
@Setter
@TableName("fyc_task")
public class FycTask implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 业务员积分任务表唯一业务ID
     */
    @TableField("fyc_task_biz_id")
    private String fycTaskBizId;

    /**
     * 业务员ID（客户端用户表唯一业务ID）
     */
    @TableField("agent_id")
    private String agentId;

    /**
     * 基本法项目配置表唯一业务ID
     */
    @TableField("rule_item_biz_id")
    private String ruleItemBizId;

    /**
     * 任务定时时间
     */
    @TableField("schedule_time")
    private LocalDateTime scheduleTime;

    /**
     * 任务状态(待执行、已执行、执行失败)
     */
    @TableField("status")
    private String status;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
