package com.yd.csf.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.feign.dto.appointmentfile.ApiAppointmentFileDto;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentFileAddRequest;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentFileEditRequest;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentFilePageRequest;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentImportExcelRequest;
import com.yd.csf.feign.response.appointmentfile.ApiAppointmentExportExcelResponse;
import com.yd.csf.feign.response.appointmentfile.ApiAppointmentFilePageResponse;
import com.yd.csf.feign.response.appointmentfile.ApiAppointmentImportExcelResponse;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

public interface ApiAppointmentFileService {

    Result<IPage<ApiAppointmentFilePageResponse>> page(ApiAppointmentFilePageRequest request);

    Result<List<ApiAppointmentFileDto>> list(String appointmentBizId);

    Result add(ApiAppointmentFileAddRequest request);

    Result edit(ApiAppointmentFileEditRequest request);

    Result del(String appointmentFileBizId);

    Result download(String appointmentFileBizId);

    Result<String> itineraryPdf(String appointmentBizId);

    Result<ApiAppointmentExportExcelResponse> appointmentExportExcel(String appointmentBizId);

    Result<ApiAppointmentImportExcelResponse> appointmentImportExcel(MultipartFile file,
                                                                     ApiAppointmentImportExcelRequest request);
}
