package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiPremiumRemittanceFileService;
import com.yd.csf.feign.client.premiumremittancefile.ApiPremiumRemittanceFileFeignClient;
import com.yd.csf.feign.dto.premiumremittancefile.ApiPremiumRemittanceFileDto;
import com.yd.csf.feign.request.premiumremittancefile.ApiPremiumRemittanceFilePageRequest;
import com.yd.csf.feign.response.premiumremittancefile.ApiPremiumRemittanceFilePageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 保费对账-汇款记录附件信息
 *
 * @author zxm
 * @since 2025-12-26
 */
@RestController
@RequestMapping("/premiumRemittanceFile")
@Validated
public class ApiPremiumRemittanceFileController implements ApiPremiumRemittanceFileFeignClient {

    @Autowired
    private ApiPremiumRemittanceFileService apiPremiumRemittanceFileService;

    /**
     * 分页列表查询-保费汇款记录附件信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiPremiumRemittanceFilePageResponse>> page(ApiPremiumRemittanceFilePageRequest request) {
        return apiPremiumRemittanceFileService.page(request);
    }

    /**
     * 添加-保费汇款记录附件信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiPremiumRemittanceFileDto request) {
        return apiPremiumRemittanceFileService.add(request);
    }

    /**
     * 编辑-保费汇款记录附件信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiPremiumRemittanceFileDto request) {
        return apiPremiumRemittanceFileService.edit(request);
    }

    /**
     * 删除-保费汇款记录附件信息
     * @param premiumRemittanceFileBizId
     * @return
     */
    @Override
    public Result del(String premiumRemittanceFileBizId) {
        return apiPremiumRemittanceFileService.del(premiumRemittanceFileBizId);
    }
}
