package com.yd.csf.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.feign.dto.premiumremittancefile.ApiPremiumRemittanceFileDto;
import com.yd.csf.feign.request.premiumremittancefile.ApiPremiumRemittanceFilePageRequest;
import com.yd.csf.feign.response.premiumremittancefile.ApiPremiumRemittanceFilePageResponse;
import com.yd.csf.service.model.PremiumRemittanceFile;

import java.util.List;

public interface ApiPremiumRemittanceFileService {

    Result<IPage<ApiPremiumRemittanceFilePageResponse>> page(ApiPremiumRemittanceFilePageRequest request);

    Result add(ApiPremiumRemittanceFileDto request);

    Result edit(ApiPremiumRemittanceFileDto request);

    Result del(String premiumRemittanceFileBizId);

    Result addPremiumRemittanceFileList(List<ApiPremiumRemittanceFileDto> apiPremiumRemittanceFileDtoList,
                                        String premiumRemittanceBizId);

    Result savePremiumRemittanceFileList(List<ApiPremiumRemittanceFileDto> apiPremiumRemittanceFileDtoList,
                                         String premiumRemittanceBizId);

    Result delByPremiumRemittanceBizId(String premiumRemittanceBizId);

    List<ApiPremiumRemittanceFileDto> apiPremiumRemittanceFileDtoList(String premiumRemittanceBizId);

    Result<PremiumRemittanceFile> checkPremiumRemittanceFileIsExist(String premiumRemittanceFileBizId);
}
