package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 查询fortune请求
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class FortuneQueryRequest extends PageDto implements Serializable {

    /**
     * 应付记录业务 id
     */
    @Schema(description = "应付记录业务 id")
    private String expectedFortuneBizId;

    /**
     * 出账状态
     */
    @Schema(description = "出账状态，可多选 0=待出账 1=可出账，待检核 2=完成出账 3=部分出账 4=保留 5=已失效 6=可出账，检核完成, 字典值: csf_fortune_status")
    private List<String> statusList;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 入账状态
     */
    @Schema(description = "入账状态，可多选 字典值: csf_expected_commission_status")
    private List<String> commissionStatusList;

    /**
     * 保险公司业务 id 列表
     */
    @Schema(description = "保险公司业务 id 列表")
    private List<String> insuranceCompanyBizIdList;

    /**
     * 产品计划业务 id 列表
     */
    @Schema(description = "产品计划业务 id 列表")
    private List<String> productLaunchBizIdList;

    /**
     * 出账日（估）开始
     */
    @Schema(description = "出账日（估）开始 格式：yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate payoutDateStart;

    /**
     * 出账日（估）结束
     */
    @Schema(description = "出账日（估）结束 格式：yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate payoutDateEnd;

    /**
     * 检核年月
     */
    @Schema(description = "检核年月，格式：yyyy-MM")
    private String reconciliationYearMonth;

    private static final long serialVersionUID = 1L;
}