package com.yd.csf.service.enums;

/**
 * 出账状态枚举
 */
public enum FortuneAccountStatusEnum {

    //出账状态枚举
    IN_PROCESS("可出账","0"),
    CANSEND("待出账","1"),
    SENT("已出账","2"),

    ;
    //字典项标签（名称）
    private String itemLabel;
    //字典项值
    private String itemValue;

    //构造函数
    FortuneAccountStatusEnum(String itemLabel, String itemValue) {
        this.itemLabel = itemLabel;
        this.itemValue = itemValue;
    }

    public String getItemLabel() {
        return itemLabel;
    }

    public String getItemValue() {
        return itemValue;
    }
}
