package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 客户信息表
 * @TableName customer
 */
@TableName(value ="customer")
@Data
public class Customer implements Serializable {
    /**
     * id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 唯一业务ID
     */
    private String customerBizId;

    /**
     * 姓名-中文
     */
    private String nameCn;

    /**
     * 姓名-（拼音/英文，通过中文自动加载全部大写的拼音）
     */
    private String namePyEn;

    /**
     * 证件类型（字典，下拉选择）
     */
    private String documentType;

    /**
     * 证件号码
     */
    private String idNumber;

    /**
     * 性别（字典，如果是身份证，自动获取性别和生日）
     */
    private String gender;

    /**
     * 出生日期（生日，如果是身份证，自动获取性别和生日）
     */
    private Date birthday;

    /**
     * 年龄（通过生日自动获取年龄）
     */
    private String age;

    /**
     * 国籍（下拉选择）
     */
    private String nationality;

    /**
     * 出生地
     */
    private String birthplace;

    /**
     * 是否拥有其他国家公民身份（如美国、日本等）: 0-否, 1-是（字典）
     */
    private String isOtherCountry;

     /**
     * 税务国家列表
     */
    private Object taxList;

    /**
     * 吸烟情况（字典）
     */
    private String smokingStatus;

    /**
     * 婚姻情况（字典）
     */
    private String maritalStatus;

    /**
     * 教育程度（字典）
     */
    private String educationLevel;

    /**
     * 是否退休（字典）
     */
    private String isRetirement;

    /**
     * 退休年龄（如已退休，再显示）
     */
    private String retirementAge;

    /**
     * 身高（CM)
     */
    private String height;

    /**
     * 体重（KG)
     */
    private String weight;

    /**
     * BMI指数（根据身高和体重自动计算）
     */
    private String bmi;

    /**
     * 风险偏好（字典，下拉选择）
     */
    private String riskAppetite;

    /**
     * 受供养人数目（通过FNA带入）
     */
    private Integer dependentsNum;

    /**
     * 移动电话区号
     */
    private String mobileCode;

    /**
     * 移动电话
     */
    private String mobile;

    /**
     * 住宅电话区号
     */
    private String residenceMobileCode;

    /**
     * 住宅电话
     */
    private String residenceMobile;

    /**
     * 固定电话区号
     */
    private String landlineCode;

    /**
     * 固定电话
     */
    private String landline;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 证件地址
     */
    private String certificateAddress;

    /**
     * 通讯地址
     */
    private String mailingAddress;

    /**
     * 居住地址（住宅地址）
     */
    private String residentialAddress;

    /**
     * 通讯地址邮政编号
     */
    private String mailingAddressCode;

    /**
     * 就业情况（字典，下拉选择）
     */
    private String employmentStatus;

    /**
     * 公司/学校名称
     */
    private String csName;

    /**
     * 行业
     */
    private String industry;

    /**
     * 现时每月收入（HKD)
     */
    private BigDecimal currentMonthlyIncome;

    /**
     * 总工作年期
     */
    private BigDecimal totalWorkingYears;

    /**
     * 受雇于现职年期
     */
    private BigDecimal currentTenure;

    /**
     * 职位
     */
    private String position;

    /**
     * 公司地址
     */
    private String companyAddress;

    /**
     * 公司电话区号
     */
    private String companyMobileCode;

    /**
     * 公司电话
     */
    private String companyMobile;

    /**
     * 公司地址邮政编号
     */
    private String companyAddressCode;

    /**
     * 平均每月收入（HKD）
     */
    private BigDecimal monthIncome;

    /**
     * 平均每月支出（HKD）
     */
    private BigDecimal monthExpenditure;

    /**
     * 总流动资产（HKD）
     */
    private BigDecimal totalCurrentAssets;

    /**
     * 总负债额（HKD）
     */
    private BigDecimal totalDebt;

    /**
     * 旅行（字典）
     */
    private String travel;

    /**
     * 运动（字典，下拉选择）
     */
    private String exercise;

    /**
     * 游戏（字典，下拉选择）
     */
    private String game;

    /**
     * 电影/戏剧（字典，下拉选择）
     */
    private String movieDrama;

    /**
     * 美食（输入）
     */
    private String delicacy;

    /**
     * 地址列表（json串）
     */
    private String addressList;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}