package com.yd.csf.service.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 应收款报表VO - 按保单号和期数维度统计
 */
@Data
public class ReceivableReportVO {
    /**
     * 应收款编号
     */
    @Schema(description = "应收款编号")
    private String receivableNo;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 对账公司
     */
    @Schema(description = "对账公司")
    private String reconciliationCompany;

    /**
     * 入账期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "入账期数")
    private Integer commissionPeriod;

    /**
     * 入账总期数
     */
    @Schema(description = "入账总期数")
    private Integer totalPeriod;

    /**
     * 入账日（估）
     */
    @Schema(description = "入账日（估）(保单生效日+2个月+(期数-1)年)")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate commissionDate;

    /**
     * 预计入账比例（%）
     */
    @Schema(description = "预计入账比例（%）")
    private BigDecimal commissionRatio;

    /**
     * 预估入账金额（原始币种）
     */
    @Schema(description = "预估入账金额（原始币种）")
    private BigDecimal amount;

    /**
     * 入账币种
     */
    @Schema(description = "入账币种")
    private String currency;

    /**
     * 预估入账金额（港币）
     */
    @Schema(description = "预估入账金额（港币）")
    private BigDecimal hkdAmount;

    /**
     * 已入账金额（港币）
     */
    @Schema(description = "已入账金额（港币）")
    private BigDecimal paidAmount;

    /**
     * 待入账金额（港币）
     */
    @Schema(description = "待入账金额（港币）")
    private BigDecimal unpaidAmount;

    /**
     * 已入账比例（%）
     */
    @Schema(description = "已入账比例（%）")
    private BigDecimal paidRatio;

    /**
     * 待入账比例（%）
     */
    @Schema(description = "待入账比例（%）")
    private BigDecimal unpaidRatio;

    /**
     * 结算汇率（估）
     */
    @Schema(description = "结算汇率（估）")
    private BigDecimal exchangeRate;

    /**
     * 保险公司
     */
    @Schema(description = "保险公司")
    private String insuranceCompany;

    /**
     * 产品计划
     */
    @Schema(description = "产品计划")
    private String productName;

    /**
     * 期交保费
     */
    @Schema(description = "期交保费")
    private BigDecimal premium;

    /**
     * 保单币种
     */
    @Schema(description = "保单币种")
    private String policyCurrency;
}
