package com.yd.csf.feign.response.variable;

import com.yd.csf.feign.dto.conditionconfig.ApiConditionTypeDto;
import com.yd.csf.feign.dto.sqltemplate.ApiCommissionSqlTemplateDto;
import lombok.Data;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ApiVariableDetailResponse {

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 变量表唯一业务ID
     */
    private String variableBizId;

    /**
     * 变量编码
     */
    private String variableCode;

    /**
     * 变量名称中文名
     */
    private String nameCn;

    /**
     * 变量名称英文名
     */
    private String nameEn;

    /**
     * 变量类型（字典: 固定值、动态计算，如果固定值这个变量取值就是value变量值这个字段，如果是动态计算需要关联条件和SQL计算对应的变量值）
     */
    private String type;

    /**
     * 变量值
     */
    private String value;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 绑定的条件类型对象
     */
    private ApiConditionTypeDto apiConditionTypeDto;

    /**
     * 绑定的SQL模板对象
     */
    private ApiCommissionSqlTemplateDto apiCommissionSqlTemplateDto;
}
