package com.yd.csf.feign.request.appointmentfile;

import lombok.Data;
import javax.validation.constraints.NotBlank;

/**
 * 新增预约附件信息入参
 */
@Data
public class ApiAppointmentFileAddRequest {

    /**
     * 预约信息主表唯一业务ID
     */
    @NotBlank(message = "预约信息主表唯一业务ID不能为空")
    private String appointmentBizId;

    /**
     * 中台文件元数据表唯一业务ID
     */
    @NotBlank(message = "中台文件元数据表唯一业务ID不能为空")
    private String ossFileBizId;

    /**
     * 文件名
     */
    @NotBlank(message = "文件名不能为空")
    private String fileName;

    /**
     * 文件访问路径
     */
    @NotBlank(message = "文件访问路径为空")
    private String fileUrl;
}
