package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class CommissionUpdateRequest {
    /**
     * 保单来佣业务id
     */
    @Schema(description = "保单来佣业务id", requiredMode = Schema.RequiredMode.REQUIRED)
    private String commissionBizId;

     /**
     * 来佣比对状态
     */
    @Schema(description = "来佣比对状态 1=比对成功 2=比对失败")
    private String status;

    /**
     * 来佣金额
     */
    @Schema(description = "来佣金额")
    private BigDecimal amount;

    /**
     * 来佣币种
     */
    @Schema(description = "来佣币种")
    private String currency;

    /**
     * 来佣日期
     */
    @Schema(description = "来佣日期")
    private Date commissionDate;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;
}
