package com.yd.csf.feign.dto.excel;

import com.yd.common.utils.DateUtil;
import com.yd.csf.feign.dto.appointment.ApiAppointmentInfoDto;
import lombok.Data;
import org.springframework.beans.BeanUtils;
import java.time.LocalDateTime;

/**
 * Excel-预约主信息
 */
@Data
public class ApiExcelAppointmentMainDto {

    //============以下是表字段============
    /**
     * 介绍人编号（用户）（预约信息主表）
     */
    private String referrerId;

//    /**
//     * 预约日期 (西元 年/月/日)（意向预约时间（年月日））（预约信息主表）
//     */
//    private LocalDateTime intentionAppointmentDate;

    /**
     * 是否体检: 0-否, 1-是（字典）（预约信息主表）
     */
    private Integer isTj;

    /**
     * 預約時間（意向预约时间）（预约信息主表）
     */
    private LocalDateTime intentionAppointmentTime;

    //============以下是excel显示的字段，同上============
    /**
     * 介绍人编号（用户）（预约信息主表）
     */
    private String mainReferrerId;

    /**
     * 预约日期 (西元 年/月/日)（意向预约时间（年月日））（预约信息主表）
     */
    private String mainIntentionAppointmentDate;

    /**
     * 是否体检: 0-否, 1-是（字典）（预约信息主表）
     */
    private Integer mainIsTj;

    /**
     * 預約時間（意向预约时间（时分））（预约信息主表）
     */
    private String mainIntentionAppointmentTime;

    /**
     * 重新赋值ApiExcelAppointmentMainDto
     * @param dto
     * @return
     */
    public static ApiExcelAppointmentMainDto setApiExcelAppointmentMainDto(ApiExcelAppointmentMainDto dto) {
        ApiExcelAppointmentMainDto mainDto = new ApiExcelAppointmentMainDto();
        BeanUtils.copyProperties(dto,mainDto);
        mainDto.setMainIntentionAppointmentDate(DateUtil.getyyyyMMdd(dto.getIntentionAppointmentTime()));
        mainDto.setMainIntentionAppointmentTime(DateUtil.getHHmm(dto.getIntentionAppointmentTime()));
        mainDto.setMainIsTj(dto.getIsTj());
        mainDto.setMainReferrerId(dto.getReferrerId());
        return mainDto;
    }

//    /**
//     * ApiExcelAppointmentMainDto构造ApiAppointmentInfoDto用于保存到表
//     * @param dto
//     * @return
//     */
//    public static ApiAppointmentInfoDto setApiAppointmentInfoDto(ApiExcelAppointmentMainDto dto) {
//        ApiAppointmentInfoDto infoDto = new ApiAppointmentInfoDto();
//        infoDto.setIntentionAppointmentTime(DateUtil.getLocalDateTime(dto.getMainIntentionAppointmentDate() + " " + dto.getMainIntentionAppointmentTime()));
//        infoDto.setIsTj(dto.getIsTj());
//        return infoDto;
//    }
}
