package com.yd.csf.feign.fallback.agentreferralrelation;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.agentreferralrelation.ApiAgentReferralRelationFeignClient;
import com.yd.csf.feign.request.agentreferralrelation.ApiAgentReferralRelationSaveRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 香港保险服务-推荐关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiAgentReferralRelationFeignFallbackFactory implements FallbackFactory<ApiAgentReferralRelationFeignClient> {
    @Override
    public ApiAgentReferralRelationFeignClient create(Throwable cause) {
        return new ApiAgentReferralRelationFeignClient() {
            @Override
            public Result save(ApiAgentReferralRelationSaveRequest request) {
                return null;
            }
        };
    }
}
