package com.yd.csf.feign.request.expectedfortune;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class ExpectedFortuneUpdateRequest {
    /**
     * 预计发佣业务id
     */
    @Schema(description = "预计发佣业务id")
    private String expectedFortuneBizId;

    /**
     * 应付款类型 R-关联保单应付款 U-非关联保单应付款
     */
    @Schema(description = "应付款类型 R-关联保单应付款 U-非关联保单应付款")
    private String fortuneBizType;

    /**
     * 出账日 (估)
     */
    @Schema(description = "出账日 (估)")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date payoutDate;

    /**
     * 出账日 (实)
     */
    @Schema(description = "出账日 (实)")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date actualPayoutDate;

    /**
     * 出账金额
     */
    @Schema(description = "出账金额")
    private BigDecimal amount;

    /**
     * 出账状态
     */
    @Schema(description = "出账状态 0=待出账 1=可出帐，待检核 2=完成出账 3=部分出账 4=保留 5=已失效 6=可出帐，检核完成 7=未找到当前预计发佣对应的来佣, 字典值: csf_expected_fortune_status")
    private String status;

    /**
     * 出账状态-修改理由
     */
    @Schema(description = "出账状态-修改理由")
    private String statusDesc;

    /**
     * 出账项目
     */
    @Schema(description = "出账项目")
    private String fortuneName;

    /**
     * 出账项目类型
     */
    @Schema(description = "出账项目类型 字典值：csf_fortune_type")
    private String fortuneType;

    /**
     * 币种
     */
    @Schema(description = "币种")
    private String currency;

    /**
     * 转介人名称
     */
    @Schema(description = "转介人名称")
    private String broker;

    /**
     * 转介人业务ID
     */
    @Schema(description = "broker biz id")
    private String brokerBizId;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;
}
