package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 预约信息日志表（快照表）
 * </p>
 *
 * @author zxm
 * @since 2025-12-15
 */
@Getter
@Setter
@TableName("appointment_log")
public class AppointmentLog implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 预约信息日志表唯一业务ID
     */
    @TableField("appointment_log_biz_id")
    private String appointmentLogBizId;

    /**
     * 预约信息主表唯一业务ID
     */
    @TableField("appointment_biz_id")
    private String appointmentBizId;

    /**
     * 预约编号
     */
    @TableField("appointment_no")
    private String appointmentNo;

    /**
     * 关联客户信息表唯一业务ID（冗余字段）
     */
    @TableField("customer_biz_id")
    private String customerBizId;

    /**
     * 关联客户编号（和客户信息表唯一业务ID是一对，唯一，冗余字段）
     */
    @TableField("customer_no")
    private String customerNo;

    /**
     * 关联FNA信息表唯一业务ID（冗余字段）
     */
    @TableField("fna_biz_id")
    private String fnaBizId;

    /**
     * 关联FNA编号（和FNA信息表唯一业务ID是一对，唯一，冗余字段）
     */
    @TableField("fna_no")
    private String fnaNo;

    /**
     * 关联计划书信息表唯一业务ID（冗余字段）
     */
    @TableField("proposal_biz_id")
    private String proposalBizId;

    /**
     * 关联计划书编号（和计划书信息表唯一业务ID是一对，唯一，冗余字段）
     */
    @TableField("proposal_no")
    private String proposalNo;

    /**
     * 是否有其他预约同时进行: 0-否, 1-是（字典）
     */
    @TableField("is_together")
    private Integer isTogether;

    /**
     * 进行同时预约的分组编号
     */
    @TableField("together_group_no")
    private String togetherGroupNo;

    /**
     * 进行同时预约的预约编号
     */
    @TableField("together_appointment_no")
    private String togetherAppointmentNo;

    /**
     * 预约状态: 0-暂存 1-待预约, 2-待签署 3-已签署 4-已取消（字典）
     */
    @TableField("status")
    private Integer status;

    /**
     * 申请类型（字典）
     */
    @TableField("apply_type")
    private String applyType;

    /**
     * 业务编号
     */
    @TableField("business_no")
    private String businessNo;

    /**
     * 意向预约时间
     */
    @TableField("intention_appointment_time")
    private LocalDateTime intentionAppointmentTime;

    /**
     * 确定预约时间
     */
    @TableField("confirm_appointment_time")
    private LocalDateTime confirmAppointmentTime;

    /**
     * 顾问是否陪同: 0-否, 1-是（字典）
     */
    @TableField("is_accompany")
    private Integer isAccompany;

    /**
     * 陪同顾问姓名（FNA Form有填写，可带入）
     */
    @TableField("accompany_name")
    private String accompanyName;

    /**
     * 陪同顾问手机区号
     */
    @TableField("accompany_mobile_code")
    private String accompanyMobileCode;

    /**
     * 陪同顾问手机
     */
    @TableField("accompany_mobile")
    private String accompanyMobile;

    /**
     * 陪同顾问邮箱
     */
    @TableField("accompany_email")
    private String accompanyEmail;

    /**
     * 业务代表1账号
     */
    @TableField("business_represent_account1")
    private String businessRepresentAccount1;

    /**
     * 业务代表1姓名
     */
    @TableField("business_represent_name1")
    private String businessRepresentName1;

    /**
     * 业务代表1电话号码区号
     */
    @TableField("business_represent_mobile1_code")
    private String businessRepresentMobile1Code;

    /**
     * 业务代表1电话号码
     */
    @TableField("business_represent_mobile1")
    private String businessRepresentMobile1;

    /**
     * 业务代表1邮箱
     */
    @TableField("business_represent_email1")
    private String businessRepresentEmail1;

    /**
     * 到港时间
     */
    @TableField("arrival_time")
    private LocalDateTime arrivalTime;

    /**
     * 离港时间
     */
    @TableField("departure_time")
    private LocalDateTime departureTime;

    /**
     * 会面地点（字典）
     */
    @TableField("meeting_point")
    private String meetingPoint;

    /**
     * 签单地址
     */
    @TableField("signing_address")
    private String signingAddress;

    /**
     * 客户在港期间联络电话区号
     */
    @TableField("hk_mobile_code")
    private String hkMobileCode;

    /**
     * 客户在港期间联络电话
     */
    @TableField("hk_mobile")
    private String hkMobile;

    /**
     * 是否开户: 0-否, 1-是（字典）
     */
    @TableField("is_open_account")
    private Integer isOpenAccount;

    /**
     * 开户行名称
     */
    @TableField("bank_name")
    private String bankName;

    /**
     * 开户行支行（分行）
     */
    @TableField("bank_branch_name")
    private String bankBranchName;

    /**
     * 开户时间段（开始）
     */
    @TableField("open_account_start_time")
    private LocalDateTime openAccountStartTime;

    /**
     * 开户时间段（结束）
     */
    @TableField("open_account_end_time")
    private LocalDateTime openAccountEndTime;

    /**
     * 开户地点
     */
    @TableField("open_account_location")
    private String openAccountLocation;

    /**
     * 开户须知
     */
    @TableField("open_account_notice")
    private String openAccountNotice;

    /**
     * 是否体检: 0-否, 1-是（字典）
     */
    @TableField("is_tj")
    private Integer isTj;

    /**
     * 是否购买过香港保险: 0-否, 1-是（字典）
     */
    @TableField("is_buy")
    private Integer isBuy;

    /**
     * 转保声明选项(字典)
     */
    @TableField("policy_transfer")
    private String policyTransfer;

    /**
     * 是否有用车服务：0-否, 1-是（字典）
     */
    @TableField("is_use_car")
    private Integer isUseCar;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 创建人用户名
     */
    @TableField("creator_name")
    private String creatorName;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
