package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 预约-转介人信息表
 * </p>
 *
 * @author zxm
 * @since 2025-12-15
 */
@Getter
@Setter
@TableName("appointment_referrer")
public class AppointmentReferrer implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 预约-转介人信息表唯一业务ID
     */
    @TableField("appointment_referrer_biz_id")
    private String appointmentReferrerBizId;

    /**
     * 预约信息主表唯一业务ID（关联）
     */
    @TableField("appointment_biz_id")
    private String appointmentBizId;

    /**
     * 系统用户-销售用户扩展表唯一业务ID（转介人，冗余）
     */
    @TableField("user_sale_biz_id")
    private String userSaleBizId;

    /**
     * 系统用户唯一业务ID（冗余）
     */
    @TableField("user_biz_id")
    private String userBizId;

    /**
     * 姓名
     */
    @TableField("real_name")
    private String realName;

    /**
     * 手机号
     */
    @TableField("phone")
    private String phone;

    /**
     * 邮箱
     */
    @TableField("email")
    private String email;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
