package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.csf.service.model.CustomerExpand;
import com.yd.csf.service.service.CustomerExpandService;
import com.yd.csf.service.dao.CustomerExpandMapper;
import org.springframework.stereotype.Service;

/**
* @author Zhang Jianan
* @description 针对表【customer_expand(CSF客户信息扩展表)】的数据库操作Service实现
* @createDate 2025-09-03 17:48:36
*/
@Service
public class CustomerExpandServiceImpl extends ServiceImpl<CustomerExpandMapper, CustomerExpand>
    implements CustomerExpandService{

    @Override
    public CustomerExpand getByCustomerBizId(String customerBizId) {
        return baseMapper.selectOne(new LambdaQueryWrapper<CustomerExpand>().eq(CustomerExpand::getCustomerBizId, customerBizId));
    }
}




