package com.yd.csf.service.dto;

import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Data
public class PolicyQueryRequest extends PageDto {

    @Schema(description = "保单状态 生效中，保单失效，期满终止，已转出，退保，被拒保，取消申请 字典值：csf_policy_status")
    private String status;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 客户名称
     */
    @Schema(description = "客户名称")
    private String customerName;

    /**
     * 客户编号
     */
    @Schema(description = "客户编号")
    private String customerBizId;

    /**
     * 保险公司
     */
    @Schema(description = "保险公司")
    private String insurer;

    /**
     * 产品名称
     */
    @Schema(description = "产品名称")
    private String productName;

    @Schema(description = "缮发日期开始")
    private String issueDateStart;

    @Schema(description = "缮发日期结束")
    private String issueDateEnd;
}
