package com.yd.csf.service.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.service.dto.CommissionExpectedAddRequest;
import com.yd.csf.service.dto.CommissionExpectedQueryRequest;
import com.yd.csf.service.dto.CommissionExpectedUpdateRequest;
import com.yd.csf.service.model.CommissionExpected;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yd.csf.service.model.Policy;
import com.yd.csf.service.vo.CommissionExpectedStatisticsVO;
import com.yd.csf.service.vo.CommissionExpectedVO;
import com.yd.csf.service.vo.ReceivableReportVO;
import com.yd.product.feign.response.expectedspecies.ApiExpectedSpeciesListResponse;

import java.util.List;

/**
* @author Zhang Jianan
* @description 针对表【commission_expected(预计来佣表)】的数据库操作Service
* @createDate 2025-10-08 19:47:40
*/
public interface CommissionExpectedService extends IService<CommissionExpected> {

    Page<CommissionExpectedVO> getCommissionExpectedVOPage(Page<CommissionExpected> commissionExpectedPage);

    /**
     * 校验数据
     *
     * @param commissionExpected
     * @param add 对创建的数据进行校验
     */
    void validCommissionExpected(CommissionExpected commissionExpected, boolean add);

    /**
     * 获取查询条件
     *
     * @param commissionExpectedQueryRequest
     * @return
     */
    QueryWrapper<CommissionExpected> getQueryWrapper(CommissionExpectedQueryRequest commissionExpectedQueryRequest);

    /**
     * 获取预计来佣封装
     *
     * @param commissionExpected
     * @return
     */
    CommissionExpectedVO getCommissionExpectedVO(CommissionExpected commissionExpected);

    Boolean addCommissionExpected(CommissionExpectedAddRequest commissionExpectedAddRequest);

    Boolean deleteCommissionExpected(String commissionExpectedBizId);

    Boolean updateCommissionExpected(CommissionExpectedUpdateRequest commissionExpectedUpdateRequest);

    CommissionExpectedStatisticsVO getExpectedStatistics(List<Long> expectedIds);

    CommissionExpected getByBizId(String commissionExpectedBizId);

    void getExpectedCommissionByProductlaunchId(Policy policy, String productLaunchBizId, String insuranceCompanyBizId, String reconciliationCompany, String reconciliationCompanyCode, String reconciliationCompanyBizId);

    List<ApiExpectedSpeciesListResponse> queryExpectedSpeciesByFeign(String productLaunchBizId);

    /**
     * 检查产品是否维护发佣信息
     *
     * @param productLaunchBizId 产品计划业务ID
     * @return true-已维护发佣信息，false-未维护发佣信息
     */
    Boolean checkProductExpectedFortune(String productLaunchBizId);

    /**
     * 应收款报表 - 按保单号和期数维度统计（分页）
     * @param page 分页参数
     * @param expectedIds 预计来佣ID列表
     * @return 应收款报表VO分页列表
     */
    IPage<ReceivableReportVO> receivableReportPage(Page<ReceivableReportVO> page, List<Long> expectedIds);
}
