package com.yd.csf.feign.request.appointment;

import com.yd.csf.feign.dto.appointment.*;
import com.yd.question.feign.dto.ApiAnswerSessionsDto;
import lombok.Data;

import javax.validation.Valid;
import java.util.List;

/**
 * 编辑预约入参
 */
@Data
public class ApiAppointmentEditRequest {

    /**
     * 来源 1-编辑提交 2-生成新单跟进提交
     */
    private Integer source = 1;

    /**
     * 预约信息
     */
    @Valid
    private ApiAppointmentInfoDto apiAppointmentInfoDto;

    /**
     * 产品计划信息
     */
    @Valid
    private ApiProductPlanInfoDto apiProductPlanInfoDto;

    /**
     * 投保人信息
     */
    @Valid
    private ApiPolicyholderInfoDto apiPolicyholderInfoDto;

    /**
     * 受保人信息
     */
    private ApiInsurantInfoDto apiInsurantInfoDto;

    /**
     * 受益人封装信息
     */
    @Valid
    private ApiBeneficiaryInfoFzDto apiBeneficiaryInfoFzDto;

    /**
     * 第二持有人信息
     */
    private ApiSecondHolderInfoDto apiSecondHolderInfoDto;

    /**
     * 健康信息 - 答题会话对象（实际回答问题的内容）集合，对象即ApiAnswerSessionsDto，一个对象一个问卷问题
     */
    private List<ApiAnswerSessionsDto> answerSessionsDtoList;

}
