package com.yd.csf.service.enums;

import org.apache.commons.lang3.ObjectUtils;

/**
 * 货币枚举
 * <p>
 * 美元
 * 人民幣
 * 港幣
 * 澳元
 * 加元
 * 欧元
 * 英鎊
 * 新加坡元
 */
public enum CurrencyEnum {
    // 货币枚举
    USD("美元", "USD"),
    CNY("人民幣", "CNY"),
    HKD("港幣", "HKD"),
    AUD("澳元", "AUD"),
    JPY("日元", "JPY"),
    CAD("加元", "CAD"),
    EUR("欧元", "EUR"),
    GBP("英镑", "GBP"),
    SGD("新加坡元", "SGD");

    //字典项标签（名称）
    private String itemLabel;
    //字典项值
    private String itemValue;

    //构造函数
    CurrencyEnum(String itemLabel, String itemValue) {
        this.itemLabel = itemLabel;
        this.itemValue = itemValue;
    }

    /**
     * 根据 币种（去掉最后一个字） 获取枚举值
     *
     * @param itemLabel
     * @return
     */
    public static String getEnumByItemLabel(String itemLabel) {
        if (ObjectUtils.isEmpty(itemLabel)) {
            return null;
        }
        // 币种名称去掉最后一个字
        itemLabel = itemLabel.substring(0, itemLabel.length() - 1);
        for (CurrencyEnum anEnum : CurrencyEnum.values()) {
            if (anEnum.itemLabel.startsWith(itemLabel)) {
                return anEnum.getItemValue();
            }
        }
        return null;
    }


    public String getItemLabel() {
        return itemLabel;
    }

    public String getItemValue() {
        return itemValue;
    }
}
